//
//  MCCDiscoveryHelperDelegate.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 11.02.10.
//  Copyright 2010 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCCDiscoveryHelper;

/*!
 @protocol	MCCDiscoveryHelperDelegate
 @abstract	The MCCDiscoveryHelperDelegate protocol defines the methods that a delegate of MCCDiscoveryHelper must implement.
 @discussion All methods are required.
 */

@protocol MCCDiscoveryHelperDelegate


- (void)discoveryHelper:(MCCDiscoveryHelper *)dh gotIPAddress:(NSString *)ipAddress andPort:(NSUInteger)port;

// We can connect to the server, but we didn't get a IP + Port because the result is not kMCSAuthorizationResultSuccess.
// e.g. Wrong password, schema older, schema newer....
- (void)discoveryHelper:(MCCDiscoveryHelper *)dh gotServerAuthError:(NSUInteger)authResult;

- (void)discoveryHelper:(MCCDiscoveryHelper *)dh didNotFindUserNamed:(NSString *)userName;
- (void)discoveryHelper:(MCCDiscoveryHelper *)dh userIsNotUsingService:(NSString *)service;


- (void)discoveryHelper:(MCCDiscoveryHelper *)dh didFailWithError:(NSError *)error;

@end
